//  Copyright (c) 2006 John Maddock
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//
// Each row of data contains in order:
//
// n, k, PI(n, k)
//
   static const boost::array<boost::array<T, 3>, 500> ellint_pi2_data = {{
      {{ SC_(-0.871743316650390625e2), SC_(0.12698681652545928955078125e0), SC_(0.1674125184786922275852201144520277497358358213892e0) }}, 
      {{ SC_(-0.871743316650390625e2), SC_(0.135477006435394287109375e0), SC_(0.16743071541243053183466547814319460702264753849723e0) }}, 
      {{ SC_(-0.871743316650390625e2), SC_(0.22103404998779296875e0), SC_(0.16768328087467940131221559947745677007068360020936e0) }}, 
      {{ SC_(-0.871743316650390625e2), SC_(0.308167040348052978515625e0), SC_(0.16807808560619590184466399113136263382376022541855e0) }}, 
      {{ SC_(-0.871743316650390625e2), SC_(0.6323592662811279296875e0), SC_(0.17122026715243530525631538196923732076962513344995e0) }}, 
      {{ SC_(-0.871743316650390625e2), SC_(0.814723670482635498046875e0), SC_(0.17534141630242782956646324755267751416323066482835e0) }}, 
      {{ SC_(-0.871743316650390625e2), SC_(0.835008561611175537109375e0), SC_(0.17605554592184937069060075230541493581360045985831e0) }}, 
      {{ SC_(-0.871743316650390625e2), SC_(0.905791938304901123046875e0), SC_(0.17950085945970126738588840411224305832081644195523e0) }}, 
      {{ SC_(-0.871743316650390625e2), SC_(0.9133758544921875e0), SC_(0.18001354683126288823677625533339788309413921715434e0) }}, 
      {{ SC_(-0.871743316650390625e2), SC_(0.968867778778076171875e0), SC_(0.1861623643134889055406196973715380337805086459718e0) }}, 
      {{ SC_(-0.8631682586669921875e2), SC_(0.12698681652545928955078125e0), SC_(0.16823313926270090905448439997177323604952165614363e0) }}, 
      {{ SC_(-0.8631682586669921875e2), SC_(0.135477006435394287109375e0), SC_(0.16825150634432729564119302859989272874459890613116e0) }}, 
      {{ SC_(-0.8631682586669921875e2), SC_(0.22103404998779296875e0), SC_(0.1685064347403877889119812191305941553416022238658e0) }}, 
      {{ SC_(-0.8631682586669921875e2), SC_(0.308167040348052978515625e0), SC_(0.16890493817434378352408134048753732273764880942954e0) }}, 
      {{ SC_(-0.8631682586669921875e2), SC_(0.6323592662811279296875e0), SC_(0.17207676229429286979803490409285729827120332255809e0) }}, 
      {{ SC_(-0.8631682586669921875e2), SC_(0.814723670482635498046875e0), SC_(0.17623726816880267488571098227884869828610508117243e0) }}, 
      {{ SC_(-0.8631682586669921875e2), SC_(0.835008561611175537109375e0), SC_(0.17695826377184426719315773208991477000910029521482e0) }}, 
      {{ SC_(-0.8631682586669921875e2), SC_(0.905791938304901123046875e0), SC_(0.18043685472666137350386874269852689421871499307432e0) }}, 
      {{ SC_(-0.8631682586669921875e2), SC_(0.9133758544921875e0), SC_(0.18095451269215495642582809340040493458719660291695e0) }}, 
      {{ SC_(-0.8631682586669921875e2), SC_(0.968867778778076171875e0), SC_(0.18716320978769236210159810482536135896363176742343e0) }}, 
      {{ SC_(-0.7767555999755859375e2), SC_(0.12698681652545928955078125e0), SC_(0.17723805469497005138970658754479684034139004976308e0) }}, 
      {{ SC_(-0.7767555999755859375e2), SC_(0.135477006435394287109375e0), SC_(0.17725833547565335175365419889134424107345532565877e0) }}, 
      {{ SC_(-0.7767555999755859375e2), SC_(0.22103404998779296875e0), SC_(0.17753984165266644170812805305717146395671420094776e0) }}, 
      {{ SC_(-0.7767555999755859375e2), SC_(0.308167040348052978515625e0), SC_(0.17797995186642175489596380169052339842058010566152e0) }}, 
      {{ SC_(-0.7767555999755859375e2), SC_(0.6323592662811279296875e0), SC_(0.18148541433576540744902539513186881476311716728227e0) }}, 
      {{ SC_(-0.7767555999755859375e2), SC_(0.814723670482635498046875e0), SC_(0.18608934162792226467645945802477829030064897877359e0) }}, 
      {{ SC_(-0.7767555999755859375e2), SC_(0.835008561611175537109375e0), SC_(0.18688773786015825638183632881144496436170974248241e0) }}, 
      {{ SC_(-0.7767555999755859375e2), SC_(0.905791938304901123046875e0), SC_(0.19074161304026152406747562924366026789550786287803e0) }}, 
      {{ SC_(-0.7767555999755859375e2), SC_(0.9133758544921875e0), SC_(0.19131534459003262670423020772987735547496828534479e0) }}, 
      {{ SC_(-0.7767555999755859375e2), SC_(0.968867778778076171875e0), SC_(0.19819980751100172478383698040644955494927942439633e0) }}, 
      {{ SC_(-0.6887512969970703125e2), SC_(0.12698681652545928955078125e0), SC_(0.18807673277332863572439323149240003591140207896313e0) }}, 
      {{ SC_(-0.6887512969970703125e2), SC_(0.135477006435394287109375e0), SC_(0.18809942894445066895052818190744724738603008664113e0) }}, 
      {{ SC_(-0.6887512969970703125e2), SC_(0.22103404998779296875e0), SC_(0.18841448356519705070217464671784444233160761372693e0) }}, 
      {{ SC_(-0.6887512969970703125e2), SC_(0.308167040348052978515625e0), SC_(0.1889071243831848858362782229683818449975108831782e0) }}, 
      {{ SC_(-0.6887512969970703125e2), SC_(0.6323592662811279296875e0), SC_(0.19283429586558276570559152326779096606423284809356e0) }}, 
      {{ SC_(-0.6887512969970703125e2), SC_(0.814723670482635498046875e0), SC_(0.19799982175435638480350130578229601669520072124985e0) }}, 
      {{ SC_(-0.6887512969970703125e2), SC_(0.835008561611175537109375e0), SC_(0.19889635678180396557867565231805298960791065374116e0) }}, 
      {{ SC_(-0.6887512969970703125e2), SC_(0.905791938304901123046875e0), SC_(0.20322643729961523231468602423697484017124986208135e0) }}, 
      {{ SC_(-0.6887512969970703125e2), SC_(0.9133758544921875e0), SC_(0.20387136735607637387480442251720783691354881786227e0) }}, 
      {{ SC_(-0.6887512969970703125e2), SC_(0.968867778778076171875e0), SC_(0.21161453485391920919877033907030403099202567227684e0) }}, 
      {{ SC_(-0.361317138671875e2), SC_(0.12698681652545928955078125e0), SC_(0.25807395141922622129192766140410293065730739479983e0) }}, 
      {{ SC_(-0.361317138671875e2), SC_(0.135477006435394287109375e0), SC_(0.25811504785027394933935002408996823143204300773286e0) }}, 
      {{ SC_(-0.361317138671875e2), SC_(0.22103404998779296875e0), SC_(0.25868576719992802882962788582860568063380617782066e0) }}, 
      {{ SC_(-0.361317138671875e2), SC_(0.308167040348052978515625e0), SC_(0.25957908488371220675239650970681566250728634199314e0) }}, 
      {{ SC_(-0.361317138671875e2), SC_(0.6323592662811279296875e0), SC_(0.26673759528219383447347331664283586398767715711549e0) }}, 
      {{ SC_(-0.361317138671875e2), SC_(0.814723670482635498046875e0), SC_(0.27624188294753047128196814230568161804652916161863e0) }}, 
      {{ SC_(-0.361317138671875e2), SC_(0.835008561611175537109375e0), SC_(0.27790012081814387436020029758750215255750597263172e0) }}, 
      {{ SC_(-0.361317138671875e2), SC_(0.905791938304901123046875e0), SC_(0.2859382172923565009441543467819242355142627417165e0) }}, 
      {{ SC_(-0.361317138671875e2), SC_(0.9133758544921875e0), SC_(0.28713902465022766561269528868552426093781301498377e0) }}, 
      {{ SC_(-0.361317138671875e2), SC_(0.968867778778076171875e0), SC_(0.30160824142871788586221637018441354445836038223767e0) }}, 
      {{ SC_(-0.17712909698486328125e2), SC_(0.12698681652545928955078125e0), SC_(0.3636729206179323089584368881165294845044180186145e0) }}, 
      {{ SC_(-0.17712909698486328125e2), SC_(0.135477006435394287109375e0), SC_(0.36375007260253424844068666864895304741725434790239e0) }}, 
      {{ SC_(-0.17712909698486328125e2), SC_(0.22103404998779296875e0), SC_(0.36482213460485031933513677664348491484058391598753e0) }}, 
      {{ SC_(-0.17712909698486328125e2), SC_(0.308167040348052978515625e0), SC_(0.3665025099771102643902474028243205860953862778759e0) }}, 
      {{ SC_(-0.17712909698486328125e2), SC_(0.6323592662811279296875e0), SC_(0.38006573775283109160868693734996149636084699279112e0) }}, 
      {{ SC_(-0.17712909698486328125e2), SC_(0.814723670482635498046875e0), SC_(0.39831093780271045079340378355274398784600363650505e0) }}, 
      {{ SC_(-0.17712909698486328125e2), SC_(0.835008561611175537109375e0), SC_(0.40151794120384245966685931317645917709530730447343e0) }}, 
      {{ SC_(-0.17712909698486328125e2), SC_(0.905791938304901123046875e0), SC_(0.41714508520694688780251187692727469785205563133695e0) }}, 
      {{ SC_(-0.17712909698486328125e2), SC_(0.9133758544921875e0), SC_(0.41948979991844566329448196311636376356543866861521e0) }}, 
      {{ SC_(-0.17712909698486328125e2), SC_(0.968867778778076171875e0), SC_(0.44789348577906501674071047048613668162470396490226e0) }}, 
      {{ SC_(-0.15664134979248046875e2), SC_(0.12698681652545928955078125e0), SC_(0.38540911235754062027100516500243302844112919081157e0) }}, 
      {{ SC_(-0.15664134979248046875e2), SC_(0.135477006435394287109375e0), SC_(0.38549479957369784596836782557901855735579578476386e0) }}, 
      {{ SC_(-0.15664134979248046875e2), SC_(0.22103404998779296875e0), SC_(0.38668559678037966531615532383662693169751820619251e0) }}, 
      {{ SC_(-0.15664134979248046875e2), SC_(0.308167040348052978515625e0), SC_(0.38855258005908474248043155982604199055563647089976e0) }}, 
      {{ SC_(-0.15664134979248046875e2), SC_(0.6323592662811279296875e0), SC_(0.4036431452565898907217581801534326597925982641061e0) }}, 
      {{ SC_(-0.15664134979248046875e2), SC_(0.814723670482635498046875e0), SC_(0.42399489399858261609254890113247088932413060034193e0) }}, 
      {{ SC_(-0.15664134979248046875e2), SC_(0.835008561611175537109375e0), SC_(0.42757740157245514965345992590002825014839199992751e0) }}, 
      {{ SC_(-0.15664134979248046875e2), SC_(0.905791938304901123046875e0), SC_(0.44505252332215040025742915418095282301447922985417e0) }}, 
      {{ SC_(-0.15664134979248046875e2), SC_(0.9133758544921875e0), SC_(0.44767679456118756417042666801411008888573438377822e0) }}, 
      {{ SC_(-0.15664134979248046875e2), SC_(0.968867778778076171875e0), SC_(0.47950133312940792812445326014374908427710586619841e0) }}, 
      {{ SC_(-0.85150146484375e1), SC_(0.12698681652545928955078125e0), SC_(0.51024420337071918152663377907810133020609909421411e0) }}, 
      {{ SC_(-0.85150146484375e1), SC_(0.135477006435394287109375e0), SC_(0.51038538213980156116084936888558434244159146142024e0) }}, 
      {{ SC_(-0.85150146484375e1), SC_(0.22103404998779296875e0), SC_(0.51234852907158154983060025475260748897671531226719e0) }}, 
      {{ SC_(-0.85150146484375e1), SC_(0.308167040348052978515625e0), SC_(0.51543084244645024279702031896115309018656014885961e0) }}, 
      {{ SC_(-0.85150146484375e1), SC_(0.6323592662811279296875e0), SC_(0.54053307124193505250530229329510213640826062354041e0) }}, 
      {{ SC_(-0.85150146484375e1), SC_(0.814723670482635498046875e0), SC_(0.57485945052545126554066528283220704394725671520491e0) }}, 
      {{ SC_(-0.85150146484375e1), SC_(0.835008561611175537109375e0), SC_(0.58095036613926759413831871317625984920620978697546e0) }}, 
      {{ SC_(-0.85150146484375e1), SC_(0.905791938304901123046875e0), SC_(0.6108332503553336432615891037745891649411427341433e0) }}, 
      {{ SC_(-0.85150146484375e1), SC_(0.9133758544921875e0), SC_(0.61534259474950438497700068371964480496721253218291e0) }}, 
      {{ SC_(-0.85150146484375e1), SC_(0.968867778778076171875e0), SC_(0.67036117324955476789547801395426121216314167238235e0) }}, 
      {{ SC_(-0.77490386962890625e1), SC_(0.12698681652545928955078125e0), SC_(0.53214537749930974923530793848098446673924558763616e0) }}, 
      {{ SC_(-0.77490386962890625e1), SC_(0.135477006435394287109375e0), SC_(0.53229733769976224201856173461401623455938844211535e0) }}, 
      {{ SC_(-0.77490386962890625e1), SC_(0.22103404998779296875e0), SC_(0.53441061264437586894262479620958694286810111069806e0) }}, 
      {{ SC_(-0.77490386962890625e1), SC_(0.308167040348052978515625e0), SC_(0.5377294161924223676286300166620738439919478705884e0) }}, 
      {{ SC_(-0.77490386962890625e1), SC_(0.6323592662811279296875e0), SC_(0.56479107742731414101881346070741395143895861655694e0) }}, 
      {{ SC_(-0.77490386962890625e1), SC_(0.814723670482635498046875e0), SC_(0.601881967717377378801568953100251074711843156646e0) }}, 
      {{ SC_(-0.77490386962890625e1), SC_(0.835008561611175537109375e0), SC_(0.6084722098461551401225157616926834919686419666249e0) }}, 
      {{ SC_(-0.77490386962890625e1), SC_(0.905791938304901123046875e0), SC_(0.6408364334233277447605831932496202047571760069003e0) }}, 
      {{ SC_(-0.77490386962890625e1), SC_(0.9133758544921875e0), SC_(0.6457242303367545109978589926395419470832321596317e0) }}, 
      {{ SC_(-0.77490386962890625e1), SC_(0.968867778778076171875e0), SC_(0.70542281927214050120129262462084303700899187217965e0) }}, 
      {{ SC_(-0.2144354343414306640625e1), SC_(0.12698681652545928955078125e0), SC_(0.8884345345550095441084403163369684177500561715756e0) }}, 
      {{ SC_(-0.2144354343414306640625e1), SC_(0.135477006435394287109375e0), SC_(0.8887968025591633966992484831363379920765936172689e0) }}, 
      {{ SC_(-0.2144354343414306640625e1), SC_(0.22103404998779296875e0), SC_(0.89384161922839613483917173517149866654437346469257e0) }}, 
      {{ SC_(-0.2144354343414306640625e1), SC_(0.308167040348052978515625e0), SC_(0.90178990573641241465368857232390076077058848312029e0) }}, 
      {{ SC_(-0.2144354343414306640625e1), SC_(0.6323592662811279296875e0), SC_(0.96773060709736540924264715674562047296122735253741e0) }}, 
      {{ SC_(-0.2144354343414306640625e1), SC_(0.814723670482635498046875e0), SC_(0.10611068880605475995293214915625250910296775013033e1) }}, 
      {{ SC_(-0.2144354343414306640625e1), SC_(0.835008561611175537109375e0), SC_(0.10780213170897016729377668066373680364223012950482e1) }}, 
      {{ SC_(-0.2144354343414306640625e1), SC_(0.905791938304901123046875e0), SC_(0.11623009444183199820310279726943206804138051586191e1) }}, 
      {{ SC_(-0.2144354343414306640625e1), SC_(0.9133758544921875e0), SC_(0.1175187305462279478043232980591313771690049845558e1) }}, 
      {{ SC_(-0.2144354343414306640625e1), SC_(0.968867778778076171875e0), SC_(0.13351521542704530399309520432473912325010294185526e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.97540400922298431396484375e-1), SC_(0.16575625537539334492135469554161301069952233501127e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.12698681652545928955078125e0), SC_(0.16604070522066793218689200133443291186241997132459e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.135477006435394287109375e0), SC_(0.16613706575726806739443199730186852538567183836454e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.188381969928741455078125e0), SC_(0.16688635821372355395722986731779999976891844033276e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.22103404998779296875e0), SC_(0.16748152996721641722488207500769930971424945210048e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.278498232364654541015625e0), SC_(0.16879215145724407449379423186230158674479606429932e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.308167040348052978515625e0), SC_(0.1696095260039130373699296075781152727841065441201e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.546881496906280517578125e0), SC_(0.18076786679621317362691990942335058424411444922867e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.54722058773040771484375e0), SC_(0.18079134451426267469684927957112878148158019786046e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.6323592662811279296875e0), SC_(0.18771472642488059146880340777640910527661803171727e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.814723670482635498046875e0), SC_(0.21465590874631142389243971571908703626422382902216e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.835008561611175537109375e0), SC_(0.2196877276017096924893565785411603522535388560468e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.905791938304901123046875e0), SC_(0.24538194571328338426625153260376589509956095921724e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.9133758544921875e0), SC_(0.24939528667597863131268459408612241086050185482663e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.957506835460662841796875e0), SC_(0.28473945726623744384547972404197314438342254491406e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.964888513088226318359375e0), SC_(0.29452299884896515169797221101771945213762664439833e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.967694938182830810546875e0), SC_(0.29882738319780340222842473815959127498505628778533e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.968867778778076171875e0), SC_(0.30074420759294457808064044871395510915970675750267e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.992881298065185546875e0), SC_(0.37936720689726111042340848424079527101282549905212e1) }}, 
      {{ SC_(0.97540400922298431396484375e-1), SC_(0.996461331844329833984375e0), SC_(0.41748893503811021098590196808435433394940293727937e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.97540400922298431396484375e-1), SC_(0.1685318587788206678609582703151072137667430882881e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.12698681652545928955078125e0), SC_(0.1688234141309562807863225412410437395324346243701e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.135477006435394287109375e0), SC_(0.16892218310996768951952246197990872503595847867976e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.188381969928741455078125e0), SC_(0.16969022709938674181625114795701672896960352436314e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.22103404998779296875e0), SC_(0.17030032321321756915384354437449120925498960973606e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.278498232364654541015625e0), SC_(0.17164390202389813987808928802179124606496793669596e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.308167040348052978515625e0), SC_(0.17248189464693526224936483136367511743274796085067e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.546881496906280517578125e0), SC_(0.18392650050287546436754219509634143238290305778196e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.54722058773040771484375e0), SC_(0.18395058974049004275826956038702022192936523369097e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.6323592662811279296875e0), SC_(0.19105592806100226980866002698193886759433999838817e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.814723670482635498046875e0), SC_(0.21873382047929470812042185849926089445838701400778e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.835008561611175537109375e0), SC_(0.22390785970553979213381814848335596881879123507617e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.905791938304901123046875e0), SC_(0.25034800740775616711131543519120042913845328201332e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.9133758544921875e0), SC_(0.25448057690068607392594067127901072224307904600547e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.957506835460662841796875e0), SC_(0.29090122069718676178130005734056487939272520282851e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.964888513088226318359375e0), SC_(0.30098999873252481469781479613235233143672874154257e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.967694938182830810546875e0), SC_(0.30542952707409075248788024261936067022168441721423e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.968867778778076171875e0), SC_(0.30740669261306918795687510838862781246976550862831e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.992881298065185546875e0), SC_(0.38856888579518839215507061538398367031048594674419e1) }}, 
      {{ SC_(0.12698681652545928955078125e0), SC_(0.996461331844329833984375e0), SC_(0.4279513831736601479703561332365938468967052418965e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.97540400922298431396484375e-1), SC_(0.16935837201668325168895896066839699010718767068277e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.12698681652545928955078125e0), SC_(0.16965205043308909205342786594130226541245100384776e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.135477006435394287109375e0), SC_(0.16975153904102123624487437670253600898007275962773e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.188381969928741455078125e0), SC_(0.17052518600413348391470247431613577572728011616544e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.22103404998779296875e0), SC_(0.17113974168351251198213980860822631882577807804365e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.278498232364654541015625e0), SC_(0.17249316899151633548906736620536069162011079023701e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.308167040348052978515625e0), SC_(0.17333732316302342704125119954235858137941450229123e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.546881496906280517578125e0), SC_(0.184867503069509046694494677902927519792373111884e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.54722058773040771484375e0), SC_(0.18489177516117682045318101631153584799577971272142e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.6323592662811279296875e0), SC_(0.19205153059652540375374119977151836226294958702724e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.814723670482635498046875e0), SC_(0.2199499240365420139762529317430872586914704970157e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.835008561611175537109375e0), SC_(0.22516656026066263576072372703627093346440038525925e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.905791938304901123046875e0), SC_(0.25183026173095013908682269375932180185911239822365e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.9133758544921875e0), SC_(0.25599858339816158797339291411962072237142485891242e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.957506835460662841796875e0), SC_(0.29274222684086696897800565119518497591155223083653e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.964888513088226318359375e0), SC_(0.30292265078919483240166428037499298822790924612329e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.967694938182830810546875e0), SC_(0.30740276265710244641438310219354706414538822113586e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.968867778778076171875e0), SC_(0.30939804989126241858406727352102049995233706253124e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.992881298065185546875e0), SC_(0.3913233944829003022188493966008570820120009850221e1) }}, 
      {{ SC_(0.135477006435394287109375e0), SC_(0.996461331844329833984375e0), SC_(0.43108509585374298111636093938509678205435530002776e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.97540400922298431396484375e-1), SC_(0.17479759608528384969249702834182411757127593245848e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.12698681652545928955078125e0), SC_(0.17510532643864074803852119143613511907598411077489e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.135477006435394287109375e0), SC_(0.17520957813802755659866732786255405040826266782146e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.188381969928741455078125e0), SC_(0.17602031152953033887075972730972713144032077197997e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.22103404998779296875e0), SC_(0.17666438708693554910808040943562680709573711171712e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.278498232364654541015625e0), SC_(0.17808301147893276383623213388114140109043953700764e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.308167040348052978515625e0), SC_(0.17896795890574749308345982233331373887522680114514e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.546881496906280517578125e0), SC_(0.1910649856118394412576272436520772884009028212601e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.54722058773040771484375e0), SC_(0.19109046951138713905781095278872332060250428340464e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.6323592662811279296875e0), SC_(0.19861096217430414986320959954875147954184860327098e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.814723670482635498046875e0), SC_(0.22797307572814278432275369755844341871230013379446e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.835008561611175537109375e0), SC_(0.23347281617333423378322997535121817827693635680977e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.905791938304901123046875e0), SC_(0.26162385239630294045076512144391733463493312713896e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.9133758544921875e0), SC_(0.26603026313647110581587719126128952747613220358229e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.957506835460662841796875e0), SC_(0.30492726931421538553273834838112076390382908238807e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.964888513088226318359375e0), SC_(0.3157193524572847165355042162261947279536891417195e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.967694938182830810546875e0), SC_(0.32047040779083038295505895978755423055324477937305e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.968867778778076171875e0), SC_(0.32258669456894960113568669221698726968013099570208e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.992881298065185546875e0), SC_(0.40961438300416806437536152922153947371679927384751e1) }}, 
      {{ SC_(0.188381969928741455078125e0), SC_(0.996461331844329833984375e0), SC_(0.45191468990067170462001406661020319085098604056066e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.97540400922298431396484375e-1), SC_(0.17842786641801211626032101629086511152515105957634e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.12698681652545928955078125e0), SC_(0.17874505058439637471101137558565348769201616102626e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.135477006435394287109375e0), SC_(0.17885250685526786408358591563239850011727800717838e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.188381969928741455078125e0), SC_(0.17968819301630796923560985137790010410356926396372e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.22103404998779296875e0), SC_(0.18035213200804066866412852295355703579687864043554e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.278498232364654541015625e0), SC_(0.18181463158362395482912828037409350308738353605753e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.308167040348052978515625e0), SC_(0.18272703492502991633858399767864007750853606366958e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.546881496906280517578125e0), SC_(0.1952058570447485461962997802235510658783335575087e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.54722058773040771484375e0), SC_(0.19523215769351016380929289372753968082675257076785e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.6323592662811279296875e0), SC_(0.20299588431676641240596482244566850561944241187449e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.814723670482635498046875e0), SC_(0.23334684357813447009475333554297143736349120311653e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.835008561611175537109375e0), SC_(0.23903816521597997220433683188795888437439141922541e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.905791938304901123046875e0), SC_(0.26819721758077360281007538596244515606316000771301e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.9133758544921875e0), SC_(0.27276520593174664663593635364598089058153237461593e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.957506835460662841796875e0), SC_(0.31312587245920801991965231814228662802474188754065e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.964888513088226318359375e0), SC_(0.32433436372252641068987215814746169200077048157468e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.967694938182830810546875e0), SC_(0.32926995362970981220807230121684723765751399497462e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.968867778778076171875e0), SC_(0.33146866615677060638089563475357588242421527248043e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.992881298065185546875e0), SC_(0.42197870205032134442583369847589743431941561017026e1) }}, 
      {{ SC_(0.22103404998779296875e0), SC_(0.996461331844329833984375e0), SC_(0.46601483850605968784815706894404192253697949618262e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.97540400922298431396484375e-1), SC_(0.18540566634013066046016566683529946117268648434283e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.12698681652545928955078125e0), SC_(0.18574118302808822333872845214608940711518291748163e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.135477006435394287109375e0), SC_(0.18585485366260202740512780428380995582238097280957e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.188381969928741455078125e0), SC_(0.18673893153616598550198271064184534621448212539342e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.22103404998779296875e0), SC_(0.18744139592431073559797146364251018882457830594932e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.278498232364654541015625e0), SC_(0.18898900325024847519171839443732244394070044486532e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.308167040348052978515625e0), SC_(0.18995467257988620333615684009042295725927955468589e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.546881496906280517578125e0), SC_(0.20317480946793513110672770770146651789418335255653e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.54722058773040771484375e0), SC_(0.20320269715624452791694861251932899530678551850235e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.6323592662811279296875e0), SC_(0.21143927529235822380297598754122162227238550408662e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.814723670482635498046875e0), SC_(0.24371677719856695336609699423201684424214845918723e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.835008561611175537109375e0), SC_(0.24978207150894544842248988916890969941974179435409e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.905791938304901123046875e0), SC_(0.28091218562371815940610134934058818213992967273169e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.9133758544921875e0), SC_(0.28579660700831643555527824701714565045938324914058e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.957506835460662841796875e0), SC_(0.32902888676544428788422667899769101501033823714241e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.964888513088226318359375e0), SC_(0.34105583872704407645425727187273935753846047487767e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.967694938182830810546875e0), SC_(0.34635431941020426477513861094373473319644588410988e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.968867778778076171875e0), SC_(0.34871515845096066296299025930425281357069563492835e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.992881298065185546875e0), SC_(0.44608991966152830064418306045679253946034036303258e1) }}, 
      {{ SC_(0.278498232364654541015625e0), SC_(0.996461331844329833984375e0), SC_(0.49355536263525154301517465906127054690444675547263e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.97540400922298431396484375e-1), SC_(0.18934415072849286883534537270895105374027937951698e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.12698681652545928955078125e0), SC_(0.18969010456990313528324707273986332428961513524659e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.135477006435394287109375e0), SC_(0.18980731328664796967088137407416123066791621258711e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.188381969928741455078125e0), SC_(0.19071894407512226317729009261893262526108362549497e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.22103404998779296875e0), SC_(0.1914433457971000130095016416527778788594881381561e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.278498232364654541015625e0), SC_(0.19303942197245427876075134028505809206514356057485e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.308167040348052978515625e0), SC_(0.19403543069828338351980236370814231957074691491496e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.546881496906280517578125e0), SC_(0.20767815321315466842055486130151844636578904709346e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.54722058773040771484375e0), SC_(0.20770694626812216009594318354463713950303390926122e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.6323592662811279296875e0), SC_(0.2162133989505660901394880457981032163263694741336e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.814723670482635498046875e0), SC_(0.24959285155980177771372901088500672286817419226303e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.835008561611175537109375e0), SC_(0.25587246398871661261602111782970214622209198828564e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.905791938304901123046875e0), SC_(0.28813411038503412607545790660946699280950409362594e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.9133758544921875e0), SC_(0.29320046792041925529200075463809734728540049118526e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.957506835460662841796875e0), SC_(0.33808682042600873923496585486523268607290153985713e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.964888513088226318359375e0), SC_(0.35058608263142767064187964281809191575384473516355e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.967694938182830810546875e0), SC_(0.35609408444130872729099130030545093427758979671065e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.968867778778076171875e0), SC_(0.35854855027778130982460095654578379147621919144728e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.992881298065185546875e0), SC_(0.45989656310722932502603549787562896818541071270379e1) }}, 
      {{ SC_(0.308167040348052978515625e0), SC_(0.996461331844329833984375e0), SC_(0.50935129182267314267802200651974704052943660558844e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.97540400922298431396484375e-1), SC_(0.23402059384453657293467992124107965599552529009311e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.12698681652545928955078125e0), SC_(0.23448883296499559512660778562285366514062997892236e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.135477006435394287109375e0), SC_(0.23464749935648314514306579097434584072840560576334e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.188381969928741455078125e0), SC_(0.23588205711140915893267134784068272159311088456764e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.22103404998779296875e0), SC_(0.2368636636131893692540900398618906215738383482657e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.278498232364654541015625e0), SC_(0.23902830778400735539589798246632587504035788545453e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.308167040348052978515625e0), SC_(0.2403804205490200482091966676317729223796453415288e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.546881496906280517578125e0), SC_(0.25899930525025210392025076967313751390713416684967e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.54722058773040771484375e0), SC_(0.25903879123238512159586351594578825450166448103094e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.6323592662811279296875e0), SC_(0.27073852391197290058024842400508946687004788910492e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.814723670482635498046875e0), SC_(0.31727236948416761145712598721593354391246222364914e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.835008561611175537109375e0), SC_(0.3261305791472119291116221293509474391044620998657e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.905791938304901123046875e0), SC_(0.37210437502805654854881865606537379706940848867438e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.9133758544921875e0), SC_(0.37938980122547451410411795703547003162802552487191e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.957506835460662841796875e0), SC_(0.44460860531472446032220008830790134979316817529627e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.964888513088226318359375e0), SC_(0.46296005991492012136799187393972414072341962778987e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.967694938182830810546875e0), SC_(0.47106996212425775717362523886778742849513268554636e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.968867778778076171875e0), SC_(0.47468822225522051131372528250655441409776888459348e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.992881298065185546875e0), SC_(0.62592213334561206278757812379308776121448544858509e1) }}, 
      {{ SC_(0.546881496906280517578125e0), SC_(0.996461331844329833984375e0), SC_(0.70060678526644476572624059809229298517936800428906e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.97540400922298431396484375e-1), SC_(0.23410830831015788690478921885268090467833699958385e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.12698681652545928955078125e0), SC_(0.23457679367857534783075167691212910410976010622334e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.135477006435394287109375e0), SC_(0.23473554356106589934395105689893554579423367634626e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.188381969928741455078125e0), SC_(0.23597075177457490068877054571644210861567238536148e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.22103404998779296875e0), SC_(0.23695287650618127134219763327896272164305623414372e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.278498232364654541015625e0), SC_(0.23911866673683800714880937923470994523878615198689e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.308167040348052978515625e0), SC_(0.24047149763368526878695351264796270952183973658547e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.546881496906280517578125e0), SC_(0.25910044388761618020160530384592627349106435553329e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.54722058773040771484375e0), SC_(0.25913995154253956534415619240009938346898696093846e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.6323592662811279296875e0), SC_(0.27084616621757254142509448233359146094363421505405e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.814723670482635498046875e0), SC_(0.31740690723504562442563357091458773172597222022389e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.835008561611175537109375e0), SC_(0.32627042317924056598645452800734223985751807327117e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.905791938304901123046875e0), SC_(0.37227260405458102322475787338451824032032350478051e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.9133758544921875e0), SC_(0.37956264857106051877485342446291322735662165311007e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.957506835460662841796875e0), SC_(0.44482404523785797098572298979971956869396955036418e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.964888513088226318359375e0), SC_(0.46318784110329691045018805600099274052196479545017e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.967694938182830810546875e0), SC_(0.47130324063820139271887152021158161845241653384549e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.968867778778076171875e0), SC_(0.4749239616253775923530987576197358638994214495136e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.992881298065185546875e0), SC_(0.6262642637182658508827584508037824879010754632838e1) }}, 
      {{ SC_(0.54722058773040771484375e0), SC_(0.996461331844329833984375e0), SC_(0.70100319160097810435985015342418148005126715043792e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.97540400922298431396484375e-1), SC_(0.25983627232663051418868321775570958012072460748809e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.12698681652545928955078125e0), SC_(0.26037785275732392483239785881702333418351081740929e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.135477006435394287109375e0), SC_(0.26056138674086001872498900704242150307776497717109e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.188381969928741455078125e0), SC_(0.26198969988017267629096785040709318163118707270417e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.22103404998779296875e0), SC_(0.26312569676074009914690028516576627934891644037609e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.278498232364654541015625e0), SC_(0.26563184471909723050750650286630705001498505755626e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.308167040348052978515625e0), SC_(0.26719799668216394367758865475061991850584635159263e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.546881496906280517578125e0), SC_(0.288819688439879797558834917870018968776292619442e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.54722058773040771484375e0), SC_(0.2888656503874529825718481477631202973076238773065e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.6323592662811279296875e0), SC_(0.30250372289870917964031675056026646037822166421746e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.814723670482635498046875e0), SC_(0.35711014838868874616408820891740595990115491538599e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.835008561611175537109375e0), SC_(0.36756637087873709930528283790637095878109736090122e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.905791938304901123046875e0), SC_(0.42211547472741855986668873394372192089361522483846e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.9133758544921875e0), SC_(0.43080015453816953780578834282306412916799677089178e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.957506835460662841796875e0), SC_(0.50896991499610565841800227351792512544656544524182e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.964888513088226318359375e0), SC_(0.5310878732509194447105180470873416299500493392777e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.967694938182830810546875e0), SC_(0.54087732500834358097505417810559652830462461181307e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.968867778778076171875e0), SC_(0.54524777170571416530775657096901515577080530647076e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.992881298065185546875e0), SC_(0.72916261680976376149891644519093021070792856467215e1) }}, 
      {{ SC_(0.6323592662811279296875e0), SC_(0.996461331844329833984375e0), SC_(0.8206051279071452115712759930474024135334921355176e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.97540400922298431396484375e-1), SC_(0.36615130852785176879217147126196463541799881957892e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.12698681652545928955078125e0), SC_(0.36700864979633107596395070657098559019273663412639e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.135477006435394287109375e0), SC_(0.36729926548863684428292981154096836334077793128303e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.188381969928741455078125e0), SC_(0.3695622112917292158123596670031321116661120758079e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.22103404998779296875e0), SC_(0.37136365958053955397815123214648429593680266151733e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.278498232364654541015625e0), SC_(0.3753429791888557405192648802824808071384639975579e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.308167040348052978515625e0), SC_(0.37783330855971643209896728200274659916197659923459e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.546881496906280517578125e0), SC_(0.41248974750692305102788633290028656131886661616047e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.54722058773040771484375e0), SC_(0.41256395922323622963124591867739410454659326872097e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.6323592662811279296875e0), SC_(0.43468399314842552835086760776534445844610545089249e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.814723670482635498046875e0), SC_(0.52516492344759917106373401745259938724176041685778e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.835008561611175537109375e0), SC_(0.54282384216898735005110179302698444547725021763189e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.905791938304901123046875e0), SC_(0.63655765710978625421767044170806252916827305938363e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.9133758544921875e0), SC_(0.65171761032367338937966048308921485471244320767902e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.957506835460662841796875e0), SC_(0.79080013108672861517726963636547052765197507865974e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.964888513088226318359375e0), SC_(0.83093785740269612723201205443816018017604080538923e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.967694938182830810546875e0), SC_(0.84880292518485436868203083795887946061156568657223e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.968867778778076171875e0), SC_(0.85679783450742635634674476722292396573956385910584e1) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.992881298065185546875e0), SC_(0.12020332533163629936712843104826393276519424710709e2) }}, 
      {{ SC_(0.814723670482635498046875e0), SC_(0.996461331844329833984375e0), SC_(0.13783442789513787913397978628707323312800999654888e2) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.97540400922298431396484375e-1), SC_(0.38802963008054803813977820674781063112347713442296e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.12698681652545928955078125e0), SC_(0.38895391979734772160215015157054948139224449450449e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.135477006435394287109375e0), SC_(0.38926724192659425309582912881127166056741746194165e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.188381969928741455078125e0), SC_(0.39170721638222319904609709155795976090510702376462e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.22103404998779296875e0), SC_(0.39364986857488306982490290273390501669776009890196e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.278498232364654541015625e0), SC_(0.39794197101665437116481203013817265441913153308358e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.308167040348052978515625e0), SC_(0.40062865216440352215470878004490299592269302610855e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.546881496906280517578125e0), SC_(0.43806514122474107817171252744847827687734389521318e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.54722058773040771484375e0), SC_(0.43814539952566439066647585754904594249419192436275e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.6323592662811279296875e0), SC_(0.46208505969966244922220805650275181772887847603741e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.814723670482635498046875e0), SC_(0.56035075626838088036778946277497254688221360812121e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.835008561611175537109375e0), SC_(0.57958928558718512744111792159030516141795211300892e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.905791938304901123046875e0), SC_(0.68200756037402605676371237410483853570652448952861e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.9133758544921875e0), SC_(0.69861672402913145091513402584010226830415229204519e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.957506835460662841796875e0), SC_(0.85150877705884914941623986455553448879155080818408e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.964888513088226318359375e0), SC_(0.89578795386774844429726843129898700651222834359108e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.967694938182830810546875e0), SC_(0.91551660991715101890645293953474342447978138513833e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.968867778778076171875e0), SC_(0.92434940401273260643322383501778685651779901094572e1) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.992881298065185546875e0), SC_(0.13076435912823550675091378685875959688120653933111e2) }}, 
      {{ SC_(0.835008561611175537109375e0), SC_(0.996461331844329833984375e0), SC_(0.1504421565973441739680443317620391346947850384558e2) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.97540400922298431396484375e-1), SC_(0.51364579743172907078177956606334136768200691940162e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.12698681652545928955078125e0), SC_(0.51496257696023639068825818964005748290918070998986e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.135477006435394287109375e0), SC_(0.51540902917564484488167174849672998637229923706362e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.188381969928741455078125e0), SC_(0.51888714963436279287864577658764974129503436908668e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.22103404998779296875e0), SC_(0.52165812761847933733068502438390992382479228542402e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.278498232364654541015625e0), SC_(0.52778590784692525793141959824818122537224169179377e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.308167040348052978515625e0), SC_(0.53162554166593582507413640409192538776659269288573e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.546881496906280517578125e0), SC_(0.58543506925299453074002624253911387553959223554261e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.54722058773040771484375e0), SC_(0.58555103820924040562602156245144190738744981411045e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.6323592662811279296875e0), SC_(0.6202567958169827869054679204190860356313582250197e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.814723670482635498046875e0), SC_(0.76501572832499288406663774761775236514109546225105e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.835008561611175537109375e0), SC_(0.79377225472182865473285917424360325745903405683922e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.905791938304901123046875e0), SC_(0.94900463169734198643429632215023502814677364131299e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.9133758544921875e0), SC_(0.97450460420686227257246008066579714693302559975407e1) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.957506835460662841796875e0), SC_(0.12131510964898459604837452008799977254024811417598e2) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.964888513088226318359375e0), SC_(0.12834895660588990914293288081732454682814420612194e2) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.967694938182830810546875e0), SC_(0.13149923831914545554837479293267667046262233705194e2) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.968867778778076171875e0), SC_(0.13291283770669908822311170345836718686878650077329e2) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.992881298065185546875e0), SC_(0.19585681570046082480269060007602416457226733145633e2) }}, 
      {{ SC_(0.905791938304901123046875e0), SC_(0.996461331844329833984375e0), SC_(0.22910032453962357735475222602715226322563404077335e2) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.97540400922298431396484375e-1), SC_(0.53567796278182966665469584408427356745925177141523e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.12698681652545928955078125e0), SC_(0.53706465742234129067461457861629097474999855664097e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.135477006435394287109375e0), SC_(0.53753482606457942010893275438728206102291514218413e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.188381969928741455078125e0), SC_(0.54119791561580716201248567906589301098388844561456e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.22103404998779296875e0), SC_(0.54411651515012617043308553999518843997537349862567e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.278498232364654541015625e0), SC_(0.55057155990987759382518984279582491917162211164108e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.308167040348052978515625e0), SC_(0.5546168237818584645561174736164368564414957147343e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.546881496906280517578125e0), SC_(0.61135330002582671691609383542179782749711281589559e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.54722058773040771484375e0), SC_(0.61147566672816086510144005271355606728942079104499e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.6323592662811279296875e0), SC_(0.64811297334058452648211641868772319591656972319772e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.814723670482635498046875e0), SC_(0.80127545785920142381956431694236596913160570851012e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.835008561611175537109375e0), SC_(0.83176457072941733649602004768408257820005022978066e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.905791938304901123046875e0), SC_(0.99668341343842981601381194961146696888338933382321e1) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.9133758544921875e0), SC_(0.10238257479066491493313528091394688111396167316168e2) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.957506835460662841796875e0), SC_(0.12784747076292409060728862092488230935384156667088e2) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.964888513088226318359375e0), SC_(0.13537303471056716895278815184682900803115035132238e2) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.967694938182830810546875e0), SC_(0.13874625808660970667807484938241285005914433501145e2) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.968867778778076171875e0), SC_(0.14026042582255128583557190331086256099368121979326e2) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.992881298065185546875e0), SC_(0.20796139036897021495721604427156454649764030962681e2) }}, 
      {{ SC_(0.9133758544921875e0), SC_(0.996461331844329833984375e0), SC_(0.24388426073727006657009940691066405054254699209927e2) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.97540400922298431396484375e-1), SC_(0.76503457787885546326326763003469710572977032523388e1) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.12698681652545928955078125e0), SC_(0.76716038040094146636619100014280517573683352145435e1) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.135477006435394287109375e0), SC_(0.7678812860097809125867733695355337577025629424427e1) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.188381969928741455078125e0), SC_(0.77350024736014462638627717330215132149507855848203e1) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.22103404998779296875e0), SC_(0.77798021744771875835629906579944080022257634051678e1) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.278498232364654541015625e0), SC_(0.78789799984887867841800756361305417821966337931214e1) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.308167040348052978515625e0), SC_(0.7941199306428990511540483495610389927659795462385e1) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.546881496906280517578125e0), SC_(0.88191722794111764041686933456482567415947996410172e1) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.54722058773040771484375e0), SC_(0.88210764827451495799425289748840141058482439587764e1) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.6323592662811279296875e0), SC_(0.93932336839051711207731683300744290557628447808303e1) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.814723670482635498046875e0), SC_(0.1182771284792391779321766802350812650995777747948e2) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.835008561611175537109375e0), SC_(0.12320281064339594429312325323042641487850186393306e2) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.905791938304901123046875e0), SC_(0.15028308241753695058976726345856425719848539377259e2) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.9133758544921875e0), SC_(0.15480853781823636289955218456536727078754603936939e2) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.957506835460662841796875e0), SC_(0.19815459918328815063517733869799796209567940407008e2) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.964888513088226318359375e0), SC_(0.21125650577195482974791118407918889633446493122218e2) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.967694938182830810546875e0), SC_(0.21717015176218797239096122108518326622341137729763e2) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.968867778778076171875e0), SC_(0.21983273474660825311562010991214769579511037177112e2) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.992881298065185546875e0), SC_(0.34339626874813658243646298235549639479779210383024e2) }}, 
      {{ SC_(0.957506835460662841796875e0), SC_(0.996461331844329833984375e0), SC_(0.4118732485739006095690261942512241046009394367706e2) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.97540400922298431396484375e-1), SC_(0.84167262598729967057913865642071548993821494056926e1) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.12698681652545928955078125e0), SC_(0.84404848302527988883063081686386807595558010595538e1) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.135477006435394287109375e0), SC_(0.84485422310717687861600860882580776993274527995783e1) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.188381969928741455078125e0), SC_(0.85113502736104862425812716756881108328230754598096e1) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.22103404998779296875e0), SC_(0.85614346351139255954712292747853411256494526120911e1) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.278498232364654541015625e0), SC_(0.86723362736902467469026276845199133670208441442384e1) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.308167040348052978515625e0), SC_(0.87419277761561037614604886852166036206851512226897e1) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.546881496906280517578125e0), SC_(0.97253254006737080595794921220432486782922159567493e1) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.54722058773040771484375e0), SC_(0.97274610510876201361265030640505359066806642641437e1) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.6323592662811279296875e0), SC_(0.10369698468565799727282608132469218660062588345402e2) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.814723670482635498046875e0), SC_(0.13113894672557015477747232414715461605318223024296e2) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.835008561611175537109375e0), SC_(0.13671308292714567667710014575103417629914128268821e2) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.905791938304901123046875e0), SC_(0.16748177061254822117866250013322346890460324928975e2) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.9133758544921875e0), SC_(0.17264321936087655821305542961641035366728631706505e2) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.957506835460662841796875e0), SC_(0.22234521214014481966700255547466683751285566923155e2) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.964888513088226318359375e0), SC_(0.23745697151087769576545138137488819387642671084236e2) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.967694938182830810546875e0), SC_(0.24429044892077737416257020472712338720954550665154e2) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.968867778778076171875e0), SC_(0.24736969743687031877602423576612072091033853979006e2) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.992881298065185546875e0), SC_(0.39177234306779981902493322275349202874120612277014e2) }}, 
      {{ SC_(0.964888513088226318359375e0), SC_(0.996461331844329833984375e0), SC_(0.47281969254496567507518866139477162178016309404814e2) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.97540400922298431396484375e-1), SC_(0.87749340894738744743694270948265096024568493541673e1) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.12698681652545928955078125e0), SC_(0.87998649741331392944767367780721513775984440721342e1) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.135477006435394287109375e0), SC_(0.88083201052130070299496002873135364634882651206055e1) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.188381969928741455078125e0), SC_(0.88742311823879947787457152537673060905294471250897e1) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.22103404998779296875e0), SC_(0.89267933850224304029991138681096743195708422942473e1) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.278498232364654541015625e0), SC_(0.90431924650688538411671046978793193394424542637885e1) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.308167040348052978515625e0), SC_(0.91162411971498806034573851810720913348772241780486e1) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.546881496906280517578125e0), SC_(0.10149105368729319979713525212670382997502111689019e2) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.54722058773040771484375e0), SC_(0.10151349673315167404426107935925233779898577793925e2) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.6323592662811279296875e0), SC_(0.10826498179194628778809247541253847637330455340384e2) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.814723670482635498046875e0), SC_(0.13716425107419425003385622658389598381007393405217e2) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.835008561611175537109375e0), SC_(0.14304409460535543297208834465727232109078639527796e2) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.905791938304901123046875e0), SC_(0.17555558471480211629722586784042312556670598890518e2) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.9133758544921875e0), SC_(0.18101822008911050431118405024371141344757697403174e2) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.957506835460662841796875e0), SC_(0.23374087333728496050939731012028166451002328394412e2) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.964888513088226318359375e0), SC_(0.24981174844716799621744382817399256981210100582671e2) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.967694938182830810546875e0), SC_(0.25708478406792358012552444041037406258993558004768e2) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.968867778778076171875e0), SC_(0.26036326769839731080468668543743674591394770667778e2) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.992881298065185546875e0), SC_(0.41481889392237843068428832454666629942434003511627e2) }}, 
      {{ SC_(0.967694938182830810546875e0), SC_(0.996461331844329833984375e0), SC_(0.50199981304225154290682359440959806846787092343051e2) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.97540400922298431396484375e-1), SC_(0.89387960113546147667107834516592095398788972888143e1) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.12698681652545928955078125e0), SC_(0.89642638328476758408330939893632176769422021470272e1) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.135477006435394287109375e0), SC_(0.89729011313113898979345204014532668421948671657144e1) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.188381969928741455078125e0), SC_(0.90402334731503204854670470706831600957975445724147e1) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.22103404998779296875e0), SC_(0.90939306132471269118663444667976091897698503909872e1) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.278498232364654541015625e0), SC_(0.92128477970475213164798905318957848196757385390116e1) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.308167040348052978515625e0), SC_(0.92874801732678048736395927457812884024802323941701e1) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.546881496906280517578125e0), SC_(0.10343008477258006353108025829292518587072018707799e2) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.54722058773040771484375e0), SC_(0.10345302574685934174662837891808443292133893745915e2) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.6323592662811279296875e0), SC_(0.11035535399525493226780130428484887916723768820463e2) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.814723670482635498046875e0), SC_(0.1399230957988262400671518493205279742530081344261e2) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.835008561611175537109375e0), SC_(0.1459432818864450018301563783872440469548427027658e2) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.905791938304901123046875e0), SC_(0.17925561066335028228279634755383640806168340759358e2) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.9133758544921875e0), SC_(0.18485677629382362314734839177253214367997580018245e2) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.957506835460662841796875e0), SC_(0.23897088120406445507944201086827395214222649925925e2) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.964888513088226318359375e0), SC_(0.25548434775250432878435321182230874558007011312145e2) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.967694938182830810546875e0), SC_(0.26296034236224140904684212101236342110325806500716e2) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.968867778778076171875e0), SC_(0.26633084441595776603520580290320433176270839636754e2) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.992881298065185546875e0), SC_(0.42544756913932307567125601985248415310848489701345e2) }}, 
      {{ SC_(0.968867778778076171875e0), SC_(0.996461331844329833984375e0), SC_(0.51548677400844300392800838671485253130848008757541e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.97540400922298431396484375e-1), SC_(0.18699656739276657313395353816657066904123921990644e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.12698681652545928955078125e0), SC_(0.18757478722906563374193631799949467330914019570454e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.135477006435394287109375e0), SC_(0.18777093567206457027427679959699782319685742366512e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.188381969928741455078125e0), SC_(0.18930084599083729385128059668237675166261690632749e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.22103404998779296875e0), SC_(0.19052199240193895593945310055717452371775388831154e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.278498232364654541015625e0), SC_(0.19322964997802663294514050078545249868423535988744e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.308167040348052978515625e0), SC_(0.19493130642004336551317918485444554537583720971045e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.546881496906280517578125e0), SC_(0.21918916261281206367305171092343155433491434321112e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.54722058773040771484375e0), SC_(0.21924227186423693776610203715720022304704645216433e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.6323592662811279296875e0), SC_(0.23529707797658380333063244192127188223302192558852e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.814723670482635498046875e0), SC_(0.30575859801875799739375471862054166647512113645807e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.835008561611175537109375e0), SC_(0.32043676668849497954006889709974841705829962521726e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.905791938304901123046875e0), SC_(0.40366423262962757965206220506997277916388787599754e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.9133758544921875e0), SC_(0.41799032567813402312687064507199400755567816106555e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.957506835460662841796875e0), SC_(0.56128172471137549389344415739570835037807068562013e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.964888513088226318359375e0), SC_(0.60675965176721448584035543697674959062919562854532e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.967694938182830810546875e0), SC_(0.6276157259900044417409413119621359487406867750706e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.968867778778076171875e0), SC_(0.63707286094632152287529888037895307035240586536621e2) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.992881298065185546875e0), SC_(0.1120903461776478755543567802910659613184060305846e3) }}, 
      {{ SC_(0.992881298065185546875e0), SC_(0.996461331844329833984375e0), SC_(0.14251487713932698105862123589172439943765575331836e3) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.97540400922298431396484375e-1), SC_(0.26525228363305081889178508646675136190937635090909e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.12698681652545928955078125e0), SC_(0.26609183579980223193874498139758348544252737042937e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.135477006435394287109375e0), SC_(0.26637665635242177149342425025355691196208309182209e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.188381969928741455078125e0), SC_(0.26859854936512317034208182700195391532482709459344e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.22103404998779296875e0), SC_(0.27037248327624528229706950425004550527856127233531e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.278498232364654541015625e0), SC_(0.27430729276514554098633382905293142866236072404168e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.308167040348052978515625e0), SC_(0.27678118753104768841544241662525580388107866876282e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.546881496906280517578125e0), SC_(0.31213240738021743521644147864390542809845218224843e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.54722058773040771484375e0), SC_(0.31220997617474390630713051844594666758716918064286e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.6323592662811279296875e0), SC_(0.33569286497756543464285670293321380122426984476525e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.814723670482635498046875e0), SC_(0.4395386723690573604089341802484590769216982250272e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.835008561611175537109375e0), SC_(0.46132844280074174499202090082014892744405520616437e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.905791938304901123046875e0), SC_(0.58587652855298148334031858334558601606458070313074e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.9133758544921875e0), SC_(0.60748367915375862531255830821598900720628098154312e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.957506835460662841796875e0), SC_(0.82625470558383026944908893678685038814065230848324e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.964888513088226318359375e0), SC_(0.89667844444233284890246553088819296424506047104969e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.967694938182830810546875e0), SC_(0.92913130201351090779050947500643074594936139585892e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.968867778778076171875e0), SC_(0.94387923495063103062113556546657899915314134335375e2) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.992881298065185546875e0), SC_(0.17241273531195384234344983626787913729253040033677e3) }}, 
      {{ SC_(0.996461331844329833984375e0), SC_(0.996461331844329833984375e0), SC_(0.22388123241793230536309311882526020237726710081432e3) }}
   }};

